/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.networking.messenger.redis;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.scheduler.v2.Scheduler;
import net.impactdev.impactor.api.scheduler.v2.Schedulers;
import net.impactdev.impactor.core.economy.networking.consumption.MessageConsumer;
import net.impactdev.impactor.core.economy.networking.messages.Message;
import net.impactdev.impactor.core.economy.networking.messenger.Messenger;
import net.impactdev.impactor.core.economy.networking.messenger.redis.RedisConfig;
import net.impactdev.impactor.relocations.redis.clients.jedis.DefaultJedisClientConfig;
import net.impactdev.impactor.relocations.redis.clients.jedis.HostAndPort;
import net.impactdev.impactor.relocations.redis.clients.jedis.JedisClientConfig;
import net.impactdev.impactor.relocations.redis.clients.jedis.JedisCluster;
import net.impactdev.impactor.relocations.redis.clients.jedis.JedisPooled;
import net.impactdev.impactor.relocations.redis.clients.jedis.JedisPubSub;
import net.impactdev.impactor.relocations.redis.clients.jedis.UnifiedJedis;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.NotNull;

public final class RedisMessenger
implements Messenger {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final PluginLogger logger;
    private final Key channel;
    private final MessageConsumer consumer;
    private @MonotonicNonNull UnifiedJedis jedis;
    private @MonotonicNonNull Subscription subscription;
    private boolean closing = false;

    public RedisMessenger(PluginLogger logger, Key channel, MessageConsumer consumer) {
        this.logger = logger;
        this.channel = channel;
        this.consumer = consumer;
    }

    public void initialize(RedisConfig config) {
        List<String> addresses = config.addresses();
        if (addresses.isEmpty()) {
            throw new RuntimeException("Cannot create redis messenger, no addresses specified...");
        }
        if (addresses.size() == 1) {
            this.initialize(new JedisPooled(RedisMessenger.parseAddress(addresses.get(0)), RedisMessenger.config(config.username(), config.password(), config.ssl())));
        } else {
            Set<HostAndPort> hosts = addresses.stream().map(RedisMessenger::parseAddress).collect(Collectors.toSet());
            this.initialize(new JedisCluster(hosts, RedisMessenger.config(config.username(), config.password(), config.ssl())));
        }
    }

    private void initialize(UnifiedJedis jedis) {
        this.jedis = jedis;
        try {
            this.jedis.ping();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to connect to target redis server", e);
        }
        this.subscription = new Subscription(this);
        Schedulers.require(Scheduler.ASYNCHRONOUS).executor().execute(this.subscription);
    }

    private static JedisClientConfig config(String username, String password, boolean ssl) {
        return DefaultJedisClientConfig.builder().user(username).password(password).ssl(ssl).timeoutMillis(2000).build();
    }

    private static HostAndPort parseAddress(String address) {
        String[] split = address.split(":");
        String host = split[0];
        int port = split.length > 1 ? Integer.parseInt(split[1]) : 6379;
        return new HostAndPort(host, port);
    }

    @Override
    public void publish(@NotNull Message message) {
        this.jedis.publish(this.channel.asString(), GSON.toJson(message.serialized()));
    }

    @Override
    public void shutdown() {
        this.closing = true;
        this.subscription.unsubscribe();
        this.jedis.close();
    }

    private static class Subscription
    extends JedisPubSub
    implements Runnable {
        private final RedisMessenger messenger;

        private Subscription(RedisMessenger messenger) {
            this.messenger = messenger;
        }

        @Override
        public void run() {
            boolean first = true;
            while (!this.messenger.closing && !Thread.interrupted() && this.isRedisAlive()) {
                try {
                    if (first) {
                        first = false;
                    } else {
                        this.messenger.logger.info("Redis pubsub connection re-established");
                    }
                    this.messenger.jedis.subscribe(this, this.messenger.channel.asString());
                }
                catch (Exception e) {
                    if (this.messenger.closing) {
                        return;
                    }
                    this.messenger.logger.warn("Redis pubsub connection dropped, trying to re-open the connection", e);
                    try {
                        this.unsubscribe();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruption) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        @Override
        public void onMessage(String channel, String message) {
            if (!channel.equals(this.messenger.channel.asString())) {
                return;
            }
            JsonObject json = (JsonObject)GSON.fromJson(message, JsonObject.class);
            this.messenger.consumer.consume((JsonElement)json);
        }

        private boolean isRedisAlive() {
            UnifiedJedis jedis = this.messenger.jedis;
            if (jedis instanceof JedisPooled) {
                JedisPooled pooled = (JedisPooled)jedis;
                return !pooled.getPool().isClosed();
            }
            if (jedis instanceof JedisCluster) {
                JedisCluster cluster = (JedisCluster)jedis;
                return !cluster.getClusterNodes().isEmpty();
            }
            throw new RuntimeException("Unknown jedis type: " + jedis.getClass().getName());
        }
    }
}

